# Handle the incoming configuration files:
config() {
  for infile in $1; do
    NEW="$infile"
    OLD="`dirname $NEW`/`basename $NEW .new`"
    # If there's no config file by that name, mv it over:
    if [ ! -r $OLD ]; then
      mv $NEW $OLD
    elif [ "`cat $OLD | md5sum`" = "`cat $NEW | md5sum`" ]; then
      # toss the redundant copy
      rm $NEW
    fi
    # Otherwise, we leave the .new copy for the admin to consider...
  done
}

preserve_perms() {
  NEW="$1"
  OLD="$(dirname ${NEW})/$(basename ${NEW} .new)"
  if [ -e ${OLD} ]; then
    cp -a ${OLD} ${NEW}.incoming
    cat ${NEW} > ${NEW}.incoming
    mv ${NEW}.incoming ${NEW}
  fi
  config ${NEW}
}

# Preserve permissions, but move this into place.  Otherwise the net
# connection could be lost at a remote location.
preserve_perms etc/rc.d/rc.shellinabox.new
config etc/sysconfig/shellinabox.new

#
# Update rc.local so that shellinabox will be started on boot
#
if ! grep "rc.shellinabox" etc/rc.d/rc.local 1>/dev/null 2>&1 ; then
  cat <<_EOM_ >> etc/rc.d/rc.local

if [ -x /etc/rc.d/rc.shellinabox ]; then
  # Start shell-in-a-box server
  echo "Starting shellinabox:    /etc/rc.d/rc.shellinabox start"
  /etc/rc.d/rc.shellinabox start
fi
_EOM_
fi

( cd usr/doc/shellinabox-2.20 ; rm -rf ChangeLog )
( cd usr/doc/shellinabox-2.20 ; ln -sf CHANGELOG.md ChangeLog )
